/*
** Praktische Aufgabe 4 --- Nullstellensuche
** Coded by Christian Buth
** 05.07.2000
**
** Version 1.00: 06.07.2000 (Fixpunktiteration und Newtonverfahren
**      implementiert)
** Version 1.10: 18.07.2000 (Anzahl dezimalen bei der Ausgabe von 6 auf 8
**      erhht.  Dies entspricht der geforderten Genauigkeit.)
*/


/*
** Includes
*/

#include <math>
#include <stdlib>
#include <fstream>
#include <iostream>
#include <iomanip>


/*
** Konstanten
*/

const double epsilon = 1E-8,
             upperbound = 1E8;


/*
** Prototypen
*/

double Fixpunktiteration(double,double (*)(double));
double Newton(double,double (*)(double),double (*)(double));
double f1(double);
double f1_prime(double);
double f2(double);
double f2_prime(double);
double f3(double);
double f3_prime(double);


/*
** main
*/

int main()
  {
    /* Begrungstext */
    cout << "Nullstellensuche von Christian Buth\n"
            "(c) 2000 Christian Buth\n\n";

    /* Nullstellensuche durch Fixpunktiteration */
    cout << "Fixpunktiteration von f1:\n";
    Fixpunktiteration(2  ,f1);
    Fixpunktiteration(4  ,f1);
    cout << "\nFixpunktiteration von f2:\n";
    Fixpunktiteration(0.1,f2);
    Fixpunktiteration(0.5,f2);
    Fixpunktiteration(2.5,f2);
    cout << "\nFixpunktiteration von f3:\n";
    Fixpunktiteration(0  ,f3);
    Fixpunktiteration(1.0,f3);
    Fixpunktiteration(1.1,f3);
    Fixpunktiteration(2.4,f3);
    Fixpunktiteration(2.5,f3);

    /* Nullstellensuche mit dem Newtonverfahren */
    cout << "\n\nNewtonverfahren auf f1:\n";
    Newton(2  ,f1,f1_prime);
    Newton(4  ,f1,f1_prime);
    cout << "\nNewtonverfahren auf f2:\n";
    Newton(0.1,f2,f2_prime);
    Newton(0.5,f2,f2_prime);
    Newton(2.5,f2,f2_prime);
    cout << "\nNewtonverfahren auf f3:\n";
    Newton(0  ,f3,f3_prime);
    Newton(1.0,f3,f3_prime);
    Newton(1.1,f3,f3_prime);
    Newton(2.4,f3,f3_prime);
    Newton(2.5,f3,f3_prime);
    return(EXIT_SUCCESS);
  }


/*
** Nullstellensuche
*/

double Fixpunktiteration(double x0,double (*f)(double))
  {
    register int n = 0;
    double x1 = x0;

    do
      {
        n++;
        x0 = x1;
        x1 = x0 + (*f)(x0);
        cout << setprecision(8) << setw(10) << setiosflags(ios::left) << x0;
        if (! (n % 5))
            cout << endl;
        else
            cout << '\t';
      }
    while (n < 30 && fabs(x1 - x0) >= epsilon && fabs(x1) < upperbound);

    if (fabs(x1) >= upperbound)
        cout << "divergent";
    else
        cout << x1;
    cout << "\n\n";
    return(x1);
  }

double Newton(double x0,double (*f)(double),double (*f_prime)(double))
  {
    register int n = 0;
    double x1 = x0;

    do
      {
        n++;
        x0 = x1;
        x1 = x0 - (*f)(x0) / (*f_prime)(x0);
        cout << setprecision(8) << setw(10) << setiosflags(ios::left) << x0;
        if (! (n % 5))
            cout << endl;
        else
            cout << '\t';
      }
    while (n < 30 && fabs(x1 - x0) >= epsilon && fabs(x1) < upperbound);

    if (fabs(x1) >= upperbound)
        cout << "divergent";
    else
        cout << x1;
    cout << "\n\n";
    return(x1);
  }


/*
** Funktionen fr die Nullstellenbestimmung
*/

double f1(double x)
  {
    return(sin(x));
  }

double f1_prime(double x)
  {
    return(cos(x));
  }

double f2(double x)
  {
    return(atan(x));
  }

double f2_prime(double x)
  {
    return(1 / (1 + x*x));
  }

double f3(double x)
  {
    double sq_x = x*x;
    return(x*sq_x - 5.9211431*sq_x + 11.146629*x - 6.468470);
  }

double f3_prime(double x)
  {
    return(3.0*x*x - 2.0*5.9211431*x + 11.146629);
  }
