/*
** Praktische Aufgabe 2 --- Quadratur
** Coded by Christian Buth
** 08.06.2000
**
** Version 1.00: 19.06.2000 (k,f werden quadriert)
*/


/*
** Includes
*/

#include <math>
#include <stdlib>
#include <fstream>
#include <iostream>
#include <iomanip>


/*
** Konstanten
*/

const int Nmax = 1024;
const double a = 0, b = 1, epsilon = 1E-10;


/*
** Prototypen
*/

void Trapezregel(double (*)(double));
void Simpsonregel(double (*)(double));
double k(double);
double f(double);


/*
** main
*/

int main()
  {
    /* Begrungstext */
    cout << "Quadratur von Christian Buth\n"
            "(c) 2000 Christian Buth\n\n";

    /* k,g quadrieren */
    cout << "Quadratur von k(x) mit der Trapezregel:\n";
    Trapezregel(k);
    cout << "\nQuadratur von k(x) mit der Simpsonregel:\n";
    Simpsonregel(k);
    cout << "\nQuadratur von f(x) mit der Trapezregel:\n";
    Trapezregel(f);
    cout << "\nQuadratur von f(x) mit der Simpsonregel:\n";
    Simpsonregel(f);
    return(EXIT_SUCCESS);
  }


/*
** Quadratur einer Funktion
*/

void Trapezregel(double (*fn)(double))
  {
    int i,N;
    double h,hold=0,I,errI=1,errIold=0,alpha;

    for (N=1; errI >= epsilon && N <= Nmax; N *= 2)
      {
	h = (b - a) / N;

	/* Berechnung der Summierten Trapezregel */
	for (i=1, I=0; i<N; i++)
	    I += (*fn)(a + i*h);
	I = ((*fn)(a) + 2 * I + (*fn)(b)) * h / 2;

	/* Fehlerabschtzung und Fehlerordnung der summierten Trapezregel */
	errI = fabs(I - M_PI);
        if (hold)
            alpha = log(errIold/errI) / log(hold / h);

        /* Ergebnis ausgeben */
        cout << "N = " << setw(4) << setiosflags(ios::left) << N
             << "    I = " << setw(15) << setprecision(13) << I << "    errI = "
             << setprecision(2) << setiosflags(ios::scientific) << errI
             << resetiosflags(ios::scientific);
        if (hold)
            cout << "    alpha = " << alpha;
        cout << endl;

        /* Werte dieses Laufs als alte Werte sichern */
        hold = h;
        errIold = errI;
      }
    return;
  }


void Simpsonregel(double (*fn)(double))
  {
    int i,N;
    double h,hold=0,I,errI=1,errIold=0,alpha;

    for (N=1; errI >= epsilon && N <= Nmax; N *= 2)
      {
	h = (b - a) / N;

	/* Berechnung der Summierten Trapezregel */
	for (i=1, I=0; i<N; i++)
	    I += 2 * (*fn)(a + i*h - h/2) + (*fn)(a + i*h);
	I = ((*fn)(a) + 2 * I + 4 * (*fn)(b - h/2) + (*fn)(b)) * h / 6;

	/* Fehlerabschtzung und Fehlerordnung der summierten Trapezregel */
	errI = fabs(I - M_PI);
        if (hold)
            alpha = log(errIold/errI) / log(hold / h);

        /* Ergebnis ausgeben */
        cout << "N = " << setw(4) << setiosflags(ios::left) << N
             << "    I = " << setw(15) << setprecision(13) << I << "    errI = "
             << setprecision(2) << setiosflags(ios::scientific) << errI
             << resetiosflags(ios::scientific);
        if (hold)
            cout << "    alpha = " << alpha;
        cout << endl;

        /* Werte dieses Laufs als alte Werte sichern */
        hold = h;
        errIold = errI;
      }
    return;
  }


/*
** Zu quadrierende Funktionen
*/


double k(double x)
  {
    return(4 * sqrt(1 - x*x));
  }


double f(double x)
  {
    return(4 / (1 + x*x));
  }
