/*
** Praktische Aufgabe 1 --- Berechnung von Interpolationspolynomen
** Coded by Christian Buth
** 31.05.2000
**
** Version 1.00: 01.06.2000 (f,g werden interpoliert)
** Version 1.10: 02.06.2000 (Fehler korrigiert)
*/


/*
** Includes
*/

#include <cmath>
#include <cstdlib>
#include <fstream>
#include <iostream>
#include <iomanip>


/*
** Konstanten
*/

const int maxStuetzStellen = 41,
          numPlotPoints = 1000;
const double a = -1, b = 1;


/*
** Prototypen
*/

void plotFunc(const char *,double (*)(double));
void plotData(const char *,const char *,const char *,int,double (*)(double));
double interpolationsPolynom(double *,double,int);
void dividierteDifferenzen(double *,int,double (*)(double));
double f(double);
double g(double);


/*
** main
*/

int main()
  {
    /* Begrungstext */
    cout << "Interpolationspolynome von Christian Buth\n"
            "(c) 2000 Christian Buth\n\n";

    /* Datenpunkte fr die Funktion f errechnen. */
    plotData("f_coeff_4.dat" ,"f_poly_4.dat" ,"f_points_4.dat" , 4,f);
    plotData("f_coeff_10.dat","f_poly_10.dat","f_points_10.dat",10,f);
    plotData("f_coeff_20.dat","f_poly_20.dat","f_points_20.dat",20,f);
    plotData("f_coeff_40.dat","f_poly_40.dat","f_points_40.dat",40,f);
    plotFunc("f_func.dat",f);

    /* Datenpunkte fr die Funktion g errechnen. */
    plotData("g_coeff_4.dat" ,"g_poly_4.dat" ,"g_points_4.dat" , 4,g);
    plotData("g_coeff_10.dat","g_poly_10.dat","g_points_10.dat",10,g);
    plotData("g_coeff_20.dat","g_poly_20.dat","g_points_20.dat",20,g);
    plotData("g_coeff_40.dat","g_poly_40.dat","g_points_40.dat",40,g);
    plotFunc("g_func.dat",g);
    return(EXIT_SUCCESS);
  }


/*
** Dateien mit Funktionswerten schreiben
*/

void plotFunc(const char *ffuncname,double (*fn)(double))
  {
    int i;
    double x;
    const double h = (b - a) / numPlotPoints;

    ofstream ffunc(ffuncname);
    for (i=0; i <= numPlotPoints; i++)
      {
        x = a + h * i;
        ffunc << x << '\t' << (*fn)(x) << endl;
      }
    return;
  }


/*
** Dateien mit Graphenpunkten und Koeffizienten schreiben
*/

void plotData(const char *fcoeffname,const char *fpolyname,
              const char *fpointsname,int n,double (*fn)(double))
  {
    int i;
    double x;
    const double h1 = (b - a) / n,
                 h2 = (b - a) / numPlotPoints;
    static double c[maxStuetzStellen];

    dividierteDifferenzen(c,n,fn);
    ofstream fcoeff(fcoeffname);
    ofstream fpoints(fpointsname);
    for (i=0; i<=n; i++)
      {
        fcoeff << "c[" << setiosflags(ios::right) << setw(n>9?2:1) << i
               << "] = " << setiosflags(ios::left) << setw(12) << c[i] << '\t';
        if (! ((i+1) % 3))
            fcoeff << endl;
        x = a + h1 * i;
        fpoints << x << '\t' << (*fn)(x) << endl;
      }
    fcoeff << endl;

    ofstream fpoly(fpolyname);
    for (i=0; i <= numPlotPoints; i++)
      {
        x = a + h2 * i;
        fpoly << x << '\t' << interpolationsPolynom(c,x,n) << endl;
      }
    return;
  }


/*
** Berechnung von Funktionswerten des Interpolationspolynoms
*/

double interpolationsPolynom(double *c,double x,int n)
  {
    int i;
    double y = c[n];
    const double h = (b - a) / n;

    for (i=n-1; i >= 0; i--)
        y = c[i] + (x - a - h * i) * y;
    return(y);
  }


/*
** Berechnung der dividierten Differenzen
*/

void dividierteDifferenzen(double *c,int n,double (*fn)(double))
  {
    register int i,k;
    double y[maxStuetzStellen], ty[maxStuetzStellen];
    const double h = (b - a) / n;

    for (i=0; i<=n; i++)
        y[i] = (*fn)(a + h * i);
    c[0] = y[0];

    for (k = 1; k <= n; k++)
      {
        for (i=0; i <= n - k; i++)
            ty[i] = (y[i+1] - y[i]) / (h * k);
        for (i=0; i <= n - k; i++)
            y[i] = ty[i];
        c[k] = y[0];
      }
    return;
  }


/*
** Zu interpolierende Funktionen
*/


double f(double x)
  {
    return(sin(M_PI * x / 2));
  }

double g(double x)
  {
    return(1.0 / (1.0 + 25.0 * x*x));
  }
