      program Accuracy_of_Derivatives
      implicit none                   


c     HiPCiP Programming Exercise 2: Accuracy of discretized derivatives
c     Coded by Chris
c     25/02/1999
       

c
c     Constants
c

      real a, b
      parameter (a=-2.0,b=2.0)         
                           

c
c     Main
c

      integer N, N1, N2, step, choice,  stdSecondDiff
      real sigma, forwardDiff, backwardDiff, centralDiff, exactDiff
      external forwardDiff, backwardDiff, centralDiff, exactDiff
      external stdSecondDiff

c     Menu
 1    write (*,*) 'Accuracy of derivatives by Christian Buth'
      write (*,*)
      write (*,*) 'Choose a task:'
      write (*,*) '  1. Compute forward, backward, central differences'
      write (*,*) '     and exact derivative of Gaussian'
      write (*,*) '  2. Compute residual for forward, backward, central'
      write (*,*) '     differences and squared residual of central '
      write (*,*) '     difference'    
      write (*,*) '  3. Compute squared residual of standard '
      write (*,*) '     approximation for the second order derivatives'
      write (*,*)
      read (*,*) choice            
      write (*,*)
      if (choice.lt.1.OR.choice.gt.3) then
         write (*,*) 'No such operation!'
         write (*,*)
         goto 1
      end if

c     Process user's choice
      write (*,*) 'Sigma for Gaussian: '
      read (*,*) sigma      
      if (choice.eq.1) then
         write (*,*) 'Number of steps: '
         read (*,*) N      
         call derivatives(a,b,N,'HiPCiP_1.dat',sigma,forwardDiff)
         call derivatives(a,b,N,'HiPCiP_2.dat',sigma,backwardDiff)
         call derivatives(a,b,N,'HiPCiP_3.dat',sigma,centralDiff)
         call derivatives(a,b,N,'HiPCiP_4.dat',sigma,exactDiff)  
      else 
         write (*,*) 'Start number of iterations: '
         read (*,*) N1
         write (*,*) 'End number of iterations: '
         read (*,*) N2
         write (*,*) 'Steps size: '
         read (*,*) step
         if (choice.eq.2) then
            call residual1(a,b,N1,N2,step,'HiPCiP-1.dat',
     &                     sigma,.FALSE.,forwardDiff)        
            call residual1(a,b,N1,N2,step,'HiPCiP-2.dat',
     &                     sigma,.FALSE.,backwardDiff)        
            call residual1(a,b,N1,N2,step,'HiPCiP-3.dat',
     &                     sigma,.FALSE.,centralDiff)        
            call residual1(a,b,N1,N2,step,'HiPCiP!1.dat',
     &                     sigma,.TRUE.,centralDiff)                 
         else
            call residual2(a,b,N1,N2,step,'HiPCiP!2.dat',sigma)      
         end if
      end if
      end !program Accuracy_of_Derivatives
      

c
c     Compute differences
c                                                   

      subroutine derivatives(a,b,N,filename,sigma,diff)
      implicit none  
      integer i, N, fn
      character*12 filename
      real a, b, x, dx, sigma, diff
      parameter (fn=10)
      external diff
      dx = (b - a) / N

      open(fn,file=filename)
      x = a
      do i=1, N-1
          x = x + dx
          write (fn,*) x, diff(x,dx,sigma)
      end do                           
      close(fn)                   
      end !subroutine derivatives
      

c
c     Compute residue for first derivatives
c                    

      subroutine residual1(a,b,N1,N2,step,filename,sigma,squared,diff)
      implicit none
      logical squared
      character*12 filename
      integer i, N, N1, N2, step, fn
      real a, b, r, x, dx, sigma, derivedGaussian, diff
      parameter (fn=10)
      external diff

      open(fn,file=filename) 
      do N = N1, N2, step
         dx = (b - a) / N
         x = a  
         r = 0
         do i=1, N
            x = x + dx
            r = r + (derivedGaussian(x,sigma) - diff(x,dx,sigma))**2
         end do      
         if (squared) then
            write (fn,*) N, 1.0 / (N-1) * r      
         else
            write (fn,*) N, sqrt(1.0 / (N-1) * r)
         end if
      end do
      close(fn)
      end !subroutine residual1
      

c
c     Compute residue for second derivative
c                    

      subroutine residual2(a,b,N1,N2,step,filename,sigma)
      implicit none
      character*12 filename
      integer i, N, N1, N2, step, fn
      real a, b, r, x, dx, sigma, derived2Gaussian, stdSecondDiff
      parameter (fn=10)

      open(fn,file=filename) 
      do N = N1, N2, step
         dx = (b - a) / N
         x = a  
         r = 0
         do i=1, N
            x = x + dx
            r = r + (derived2Gaussian(x,sigma) - stdSecondDiff
     &          (x,dx,sigma))**2
         end do      
         write (fn,*) N, 1.0 / (N-1) * r      
      end do
      close(fn)
      end !subroutine residual2


c
c     Forward difference
c                       

      real function forwardDiff(x,dx,sigma)
      implicit none
      real x, dx, sigma, Gaussian

      forwardDiff = (Gaussian(x + dx,sigma) - Gaussian(x,sigma)) / dx
      end !function forwardDiff


c
c     Backward difference
c                       

      real function backwardDiff(x,dx,sigma)
      implicit none
      real x, dx, sigma, Gaussian

      backwardDiff = (Gaussian(x,sigma) - Gaussian(x - dx,sigma)) / dx
      end !function backwardDiff
      

c
c     Central difference
c                       

      real function centralDiff(x,dx,sigma)
      implicit none
      real x, dx, sigma, Gaussian

      centralDiff = (Gaussian(x + dx,sigma) - Gaussian(x - dx,sigma)) /
     &              (2.0 * dx)               
      end !function centralDiff   
      

c
c     Second order difference
c                            

      real function stdSecondDiff(x,dx,sigma)
      implicit none
      real x, dx, sigma, Gaussian

      stdSecondDiff = (Gaussian(x + dx,sigma) + Gaussian(x - dx,sigma)
     &                - 2.0 * Gaussian(x,sigma)) / dx**2
      end !function stdSecondDiff


c
c     Exact derivative
c            

      real function exactDiff(x,dx,sigma)
      implicit none
      real x, dx, sigma, derivedGaussian

      exactDiff = derivedGaussian(x,sigma)
      end !function exactDiff
      

c
c     Gaussian
c

      real function Gaussian(x,sigma)
      implicit none
      real x, sigma

      Gaussian = exp(-x*x / (2.0*sigma*sigma))               
      end !function Gaussian              
      

c
c     Derived Gaussian
c

      real function derivedGaussian(x,sigma)
      implicit none
      real x, sigma

      derivedGaussian = -x / (sigma * sigma) 
     &                  * exp(-x*x / (2.0*sigma*sigma))               
      end !function derivedGaussian


c
c     Second derivative of Gaussian
c

      real function derived2Gaussian(x,sigma)
      implicit none
      real x, sigma

      derived2Gaussian = (x*x / (sigma * sigma) - 1.0) / (sigma*sigma)
     &                   * exp(-x*x / (2.0*sigma*sigma))               
      end !function derived2Gaussian      


