      program Traffic_Jam
      implicit none

c     Title: HiPCiP Programming Exercise 1: Cellular Automaton 
c     Author: Christian Buth
c     Date: 21/01/1999


c
c     Main
c

c     Variables
      character answer
      integer n, fn
      parameter (fn=10, n=100)
      integer c(0:n+1), i, nsteps, nsim, s, status
      real density, actdensity, initialize, v, updateCells

c     Initialisation
      write (*,*) 'Traffic Jam by Christian Buth'
      write (*,*)
      write (*,*) 'Do you want to do successive simulations (Y/N)?'
      read (*,*) answer
      if (answer.eq.'n'.OR.answer.eq.'N') then
         write (*,*) 'Do you want to do a visual simulation (Y/N)?'
         read (*,*) answer
         if (answer.eq.'n'.OR.answer.eq.'N') then
            status = 1
         else
            status = 2
         end if
         write (*,*) 'Specify density:'
         read (*,*) density
         nsim = 1
      else
         write (*,*) 'Number of densities:'
         read (*,*) nsim
         status = 3
      end if
      write (*,*) 'Number of steps:'
      read (*,*) nsteps

c     Do all simulations
      open(fn,file='HiPCiP1.dat')
      do s = 1, nsim
         if (status.eq.3) then
            density = s
            density = density / nsim
         end if
         actdensity =  initialize(c,n,density) 
         if (status.eq.2) call displayGen(c,n,fn)

c        Do one simulation
         do i=1, nsteps
            v = updateCells(c,n)
            if (status.eq.2) then
               write (fn,*) 'Velocity:',v
               write (fn,*)
               call displayGen(c,n,fn)
            end if
            if (status.eq.1) write (fn,*) i,v
         end do
         if (status.eq.3) write (fn,*) actdensity,v
      end do
      close(fn)
      end program Traffic_Jam


c       
c     Set up array with cars
c

      real function initialize(c,n,density)
      implicit none
      real uni, rand, density, actdensity
      integer i, n, c(0:n+1), seed

c     Initialize random number generator
      seed = 150275
      call rinit(seed)

c     Fill array
      do i=1, n
         rand = uni()
         if (rand.lt.density) then
            c(i) = 1
         else
            c(i) = 0
         end if
      end do

c     Calculate real alpha
      actdensity = 0
      do i=1, n
         if (c(i).eq.1) actdensity = actdensity + 1
      end do
      actdensity = actdensity / n
      write (*,*) 'Density of cars:',actdensity,'  Should be:',density
      initialize = actdensity
      end function initialize


c
c     Display generation
c

      subroutine displayGen(c,n,fn)
      implicit none
      integer n,c(0:n+1),i,fn
      character s(n)
      
      do i = 1, n
         if (c(i).eq.1) then
            s(i) = '*'
         else
            s(i) = ' '
         end if
      end do
      write (fn,*) (s(i), i = 1, n)
      end subroutine displayGen


c
c     Update cells
c

      real function updateCells(c,n)
      implicit none
      integer i,n,b(0:n+1),c(0:n+1)
      real v
      
      c(0) = c(n)
      c(n+1) = c(1)
      v = 0
      do i=1, n
         if (c(i).eq.1) then
            if (c(i+1).eq.1) then
               b(i) = 1
            else
               b(i) = 0
            end if
         else
            if (c(i-1).eq.1) then
               b(i) = 1
               v = v + 1
            else
               b(i) = 0
            end if
         end if
      end do

      do i=1, n
         c(i) = b(i)
      end do

c     Write graph data
      v = v / n
      updateCells = v
      end function updateCells





















